/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275d;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class BoxInfo {
    private static ResourceBundle myBundle;
    private static String bundleName;
    public static final String PROPNAME = "BoxInfo.jdm8275d.nways.ibm";
    public static final String serPath = "ibm.nways.jdm8275d.WCDefault";
    public static final int TIMEOUT_REPEAT = 5;
    public static final int RASID = 19;
    public static final int RASSUB = 8;
    public static final String CARDINALoid = "1.3.6.1.4.1.2.3.46";
    public static final String RAVENoid = "1.3.6.1.4.1.2.3.47";
    public static final int MODELunknown = -1;
    public static final int MODEL324 = 0;
    public static final int MODEL318 = 1;
    public static final int MODEL322 = 2;
    public static final int MODEL326 = 3;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    private OIDInfo oidInfo;
    private UFCInfo ufcInfo;
    private int[] UFCarray;
    private GenModel deviceModel;
    private GenModel modulesModel;
    private GenModel portModel;
    private GenModel interfaceModel;
    private GenModel systemModel;
    private JdmBrowser deviceBrowser;
    private int deviceStatus;
    private int retrievalStatus;
    private int currentBoxModel;
    private GraphicPanel deviceGraphic;
    private OID deviceSysOID;
    GraphicPanel graphicPanel;
    GraphicContainer grContainer;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        ModelInfo modelInfo = null;
        Serializable serializable = null;
        String string = "BoxInfo";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        this.oidInfo = new OIDInfo();
        this.ufcInfo = new UFCInfo();
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        myBundle = ResourceBundle.getBundle(bundleName);
        try {
            modelInfo = this.deviceModel.getInfo("Initial");
            serializable = modelInfo.get("Initial.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                this.deviceStatus = 2;
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Device not responding" + serializable.toString());
                }
                new BoxDownMsg(jdmBrowser.getFrame(), myBundle.getString("deviceName"));
            } else {
                this.deviceSysOID = new OID(serializable.toString());
                if (this.oidInfo.containsKey(this.deviceSysOID)) {
                    this.deviceStatus = 1;
                    this.retrievalStatus = this.getNecessaryModels();
                } else {
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string, "Wrong device. SysOID = " + this.deviceSysOID);
                    }
                    this.deviceStatus = 3;
                    new WrongSysOidMsg(this.deviceBrowser.getFrame(), myBundle.getString("deviceName"));
                }
            }
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Error getting initial SysOID data");
            }
            RAS.logException(19, 8, this, string, exception);
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
    }

    private int getNecessaryModels() {
        int n = 0;
        int n2 = 1;
        String string = "getNecessaryModels";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.trace(19, 8, this, string, "Attempting to retrieve the following componenets : \n\t Ports - System - Modules - Interface");
        }
        try {
            this.portModel = (GenModel)this.deviceModel.getComponent("Ports");
            n2 = 2;
            this.systemModel = (GenModel)this.deviceModel.getComponent("System");
            n2 = 3;
            this.modulesModel = (GenModel)this.deviceModel.getComponent("Modules");
            n2 = 4;
            this.interfaceModel = (GenModel)this.deviceModel.getComponent("Interface");
        }
        catch (Exception exception) {
            n = 1;
            if (n2 == 4) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Trouble getting component 'Interface'");
                }
            } else if (n2 == 3) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Trouble getting component 'Modules' ");
                }
            } else if (n2 == 2) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Trouble getting component 'System' ");
                }
            } else if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Trouble getting component 'Ports' ");
            }
            RAS.logException(19, 8, this, string, exception);
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
        return n;
    }

    public GraphicPanel getDeviceGraphic() {
        String string = "getDeviceGraphic";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        if (this.deviceStatus == 1 && this.oidInfo.isGifReady(this.deviceSysOID) && this.retrievalStatus == 0) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Getting the device graphic");
            }
            this.currentBoxModel = this.processUFC();
            if (this.deviceGraphic != null) {
                return this.deviceGraphic;
            }
            JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
            jdmLayout.setScheme(this.oidInfo.getScheme(this.deviceSysOID));
            this.grContainer = new GraphicContainer();
            GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
            this.grContainer.add((GraphicComponent)graphicHelp);
            CookieTray cookieTray = this.currentBoxModel != -1 ? this.createModel(this.deviceSysOID) : null;
            if (cookieTray != null) {
                this.grContainer.add((GraphicContainer)cookieTray);
            } else {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "There was an error in retrieving the data to construct the box");
                }
                Label label = new Label(myBundle.getString("GraphicNotAvailable"), 1);
                label.setLocation(new Point(50, 50));
                label.setFont(new Font("Arial", 1, 14));
                this.grContainer.add(label);
            }
        } else {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "No information to construct the device graphic is available.");
            }
            this.grContainer = new GraphicContainer();
            Label label = new Label(myBundle.getString("GraphicNotAvailable"), 1);
            label.setLocation(new Point(50, 50));
            label.setFont(new Font("Arial", 1, 14));
            this.grContainer.add(label);
        }
        this.graphicPanel = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)this.grContainer);
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
        return this.graphicPanel;
    }

    public int processUFC() {
        Vector vector = null;
        ModelInfo modelInfo = null;
        int n = this.getNumOfSlots();
        int n2 = -1;
        boolean bl = false;
        String string = "processUFC";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        this.UFCarray = new int[n + 1];
        ModelInfo modelInfo2 = null;
        boolean bl2 = true;
        try {
            if (this.modulesModel != null) {
                int n3 = 0;
                while (n3 < 5 && bl2) {
                    vector = this.modulesModel.getRestOfInfo("Panel", "default", modelInfo2, null);
                    bl2 = false;
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string, "Retrieving the UFC information, attempt = " + n3);
                    }
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        modelInfo = (ModelInfo)vector.elementAt(n4);
                        if (!modelInfo.timeoutDetected) {
                            modelInfo2 = modelInfo;
                            Serializable serializable = modelInfo.get("Panel.SwSlotInfoId");
                            if (serializable instanceof Integer) {
                                int n5 = (Integer)serializable;
                                Serializable serializable2 = modelInfo.get("Panel.SwSlotInfoType");
                                if (serializable2 instanceof Integer) {
                                    this.UFCarray[n5] = (Integer)serializable2;
                                } else {
                                    bl = true;
                                }
                            } else {
                                bl = true;
                            }
                        } else {
                            if (RAS.isEnabled(19, 8)) {
                                RAS.trace(19, 8, this, string, "TimeOUTS !!!!");
                            }
                            if (n4 > 0) {
                                --n3;
                            }
                            bl2 = true;
                            break;
                        }
                        if (bl) {
                            if (RAS.isEnabled(19, 8)) {
                                RAS.trace(19, 8, this, string, "Error at ufc i = " + n4);
                            }
                            bl2 = true;
                            break;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            } else {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Warning ... Modules model is NULL !!");
                }
                if (this.deviceSysOID.toString().equals(CARDINALoid)) {
                    this.UFCarray[1] = 2;
                }
            }
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Trouble getting Modules information");
            }
            RAS.logException(19, 8, this, string, exception);
            bl = true;
        }
        if (bl) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "There was an error in retrieving the data to determine the box model");
                RAS.exit(19, 8, this, string);
            }
            return n2;
        }
        if (this.deviceSysOID.toString().equals(CARDINALoid)) {
            if (this.UFCarray[1] == 2) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Model is 8275-324");
                }
                n2 = 0;
            }
        } else if (this.deviceSysOID.toString().equals(RAVENoid)) {
            if (this.UFCarray[1] == 5) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Model is 8275-318");
                }
                n2 = 1;
            } else if (this.UFCarray[2] == 5) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Model is 8275-322");
                }
                n2 = 2;
            } else if (this.UFCarray[2] == 3) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, " Model is 8275-326");
                }
                n2 = 3;
            }
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
        return n2;
    }

    public CookieTray createModel(OID oID) {
        Integer n;
        Serializable serializable;
        Serializable serializable2;
        WidgetCookie widgetCookie;
        String string;
        String string2 = new String("ibm.nways.jdm8275d.eui.PortsPanel");
        String string3 = null;
        String string4 = null;
        Point point = new Point(-1, -1);
        CookieTray cookieTray = null;
        int n2 = 0;
        new Integer(-99);
        String string5 = new String();
        String[] stringArray = null;
        CookieTray[] cookieTrayArray = null;
        String string6 = "createModel";
        NavigationContext navigationContext = null;
        GraphicActionNavigate graphicActionNavigate = null;
        ModelInfo modelInfo = null;
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string6);
        }
        try {
            string3 = new String("/ibm/nways/jdm8275d/" + this.oidInfo.getImage(oID));
            string4 = new String(this.oidInfo.getModel(oID));
            stringArray = new String[this.UFCarray.length];
            cookieTrayArray = new CookieTray[this.UFCarray.length];
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string6, "Error retrievig the data from the OID table");
            }
            RAS.logException(19, 8, this, string6, exception);
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.trace(19, 8, this, string6, "Creating " + string4 + "'s backplane\n\tWith image named " + string3);
        }
        try {
            cookieTray = new CookieTray(bundleName, this.oidInfo.getPosition(oID), string3, String.valueOf(string4) + "_" + this.currentBoxModel, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string6, " Error attempting to create " + string4 + "_" + this.currentBoxModel);
            }
            RAS.logException(19, 8, this, string6, exception);
        }
        int n3 = 0;
        while (n3 < this.oidInfo.getNumOfExtras(oID)) {
            string = new String(String.valueOf(string4) + this.oidInfo.getExtras(oID, n3));
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string6, " Creating extra port " + string);
            }
            try {
                widgetCookie = new WidgetCookie(string, bundleName, null, serPath, null, this.deviceBrowser, 22);
                cookieTray.AddWidget(widgetCookie);
            }
            catch (NullPointerException nullPointerException) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string6, " Error attempting to create widget cookie " + string);
                }
                RAS.logException(19, 8, this, string6, (Exception)nullPointerException);
            }
            ++n3;
        }
        int n4 = 1;
        while (n4 < this.UFCarray.length) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.SwSlotInfoId", new Integer(n4));
            navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow((NavigationContext)navigationContext, (ModelInfo)modelInfo);
            navigationContext.setParent(this.deviceBrowser.getNavigationTree().getNavContext());
            graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.deviceBrowser, new NavigationDestination("ibm.nways.jdm8275d.eui.ModulesPanel", (RemoteModel)this.modulesModel), navigationContext);
            serializable2 = new Integer(this.UFCarray[n4]);
            if (this.ufcInfo.displayIt((Integer)serializable2)) {
                String string7 = this.ufcInfo.getName((Integer)serializable2);
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string6, " Slot " + n4 + " has " + string7);
                }
                String string8 = this.ufcInfo.getImage((Integer)serializable2);
                String string9 = new String("/ibm/nways/jdm8275d/" + string8);
                serializable = new Point(this.oidInfo.getSlotCoords(oID, n4));
                if (!((Point)serializable).equals(point)) {
                    try {
                        n = new CookieTray(bundleName, (Point)serializable, string9, string7, this.deviceBrowser, graphicActionNavigate);
                        cookieTrayArray[n4] = n;
                        stringArray[n4] = string7;
                    }
                    catch (Exception exception) {
                        ++n2;
                        if (RAS.isEnabled(19, 8)) {
                            RAS.trace(19, 8, this, string6, " There was an error creating the graphic for a UFC !!!");
                            RAS.trace(19, 8, this, string6, " When attempted to create cookie tray " + string7);
                        }
                        RAS.logException(19, 8, this, string6, exception);
                    }
                } else if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string6, "Error , there is no slot number " + n4 + " in this box");
                }
            }
            ++n4;
        }
        serializable2 = null;
        boolean bl = true;
        int n5 = 0;
        while (n5 < 5 && bl) {
            Vector vector;
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string6, " Retrieving the port information. Attempt " + n5);
            }
            try {
                vector = this.portModel.getRestOfInfo("Graphics", "default", (ModelInfo)serializable2, null);
                int n6 = 1;
                while (n6 <= vector.size()) {
                    Serializable serializable3;
                    Serializable serializable4;
                    serializable = (ModelInfo)vector.elementAt(n6 - 1);
                    n = null;
                    Integer n7 = null;
                    Integer n8 = null;
                    bl = false;
                    if (((ModelInfo)serializable).timeoutDetected) {
                        bl = true;
                        if (RAS.isEnabled(19, 8)) {
                            RAS.trace(19, 8, this, string6, " TimeOUTS !! while adding ports ...");
                        }
                        if (n6 <= 1) break;
                        --n5;
                        break;
                    }
                    serializable2 = serializable;
                    Serializable serializable5 = ((ModelInfo)serializable).get("Index.Port");
                    if (serializable5 instanceof Integer) {
                        n = (Integer)serializable5;
                    }
                    if ((serializable4 = ((ModelInfo)serializable).get("Index.Slot")) instanceof Integer) {
                        n7 = (Integer)serializable4;
                    }
                    if ((serializable3 = ((ModelInfo)serializable).get("Graphics.SwPortIfIndex")) instanceof Integer) {
                        n8 = (Integer)serializable3;
                    }
                    ModelInfo modelInfo2 = null;
                    modelInfo2 = new ModelInfo();
                    ModelInfo modelInfo3 = null;
                    modelInfo3 = new ModelInfo();
                    modelInfo2.add("Index.Slot", n7);
                    modelInfo2.add("Index.Port", n);
                    modelInfo3.add("Index.IfIndex", n8);
                    if (n7 < stringArray.length) {
                        string5 = stringArray[n7];
                        if (string5 != null) {
                            string = new String(String.valueOf(string5) + "Port" + n);
                            try {
                                widgetCookie = new WidgetCookie(string, bundleName, modelInfo3, serPath, this.interfaceModel, this.deviceBrowser, 18);
                                widgetCookie.SetAction(this.portModel, modelInfo2, string2);
                                I18NMsgFormat i18NMsgFormat = null;
                                Object[] objectArray = new Integer[]{n, n7};
                                i18NMsgFormat = new I18NMsgFormat(bundleName, "PortSlot", objectArray);
                                String string10 = i18NMsgFormat.getTranslation();
                                widgetCookie.GetImage().setFlyOver(new GraphicFlyOver(string10));
                                widgetCookie.GetImage().getStatus().setName(i18NMsgFormat);
                                cookieTrayArray[n7].AddWidget(widgetCookie);
                            }
                            catch (Exception exception) {
                                if (RAS.isEnabled(19, 8)) {
                                    RAS.trace(19, 8, this, string6, " There was an error in creating " + string);
                                }
                                RAS.logException(19, 8, this, string6, exception);
                            }
                        } else if (RAS.isEnabled(19, 8)) {
                            RAS.trace(19, 8, this, string6, " Error - There is no UFC installed on slot " + n7);
                            RAS.trace(19, 8, this, string6, " Can not draw port " + n);
                        }
                    } else if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string6, " Error - There are only " + (stringArray.length - 1) + " slots on this box");
                        RAS.trace(19, 8, this, string6, " Can not draw port " + n + " on slot " + n7);
                    }
                    ++n6;
                }
                int n9 = 1;
                while (n9 < cookieTrayArray.length) {
                    if (cookieTrayArray[n9] != null) {
                        cookieTray.add((GraphicContainer)cookieTrayArray[n9]);
                    }
                    ++n9;
                }
            }
            catch (Exception exception) {
                vector = new Vector();
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string6, " BoxInfo: Trouble getting models");
                }
                RAS.logException(19, 8, this, string6, exception);
                break;
            }
            ++n5;
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string6);
        }
        return cookieTray;
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public int getNumOfSlots() {
        return this.oidInfo.getNumSlots(this.deviceSysOID);
    }

    public int getModelType() {
        return this.currentBoxModel;
    }

    public void dispose() {
        String string = "dispose";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
        if (this.oidInfo != null) {
            this.oidInfo.dispose();
            this.oidInfo = null;
        }
        if (this.ufcInfo != null) {
            this.ufcInfo.dispose();
            this.ufcInfo = null;
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
    }

    static {
        bundleName = "ibm.nways.jdm8275d.GeneralResources";
    }

    private class OIDTable
    extends Hashtable {
        public void create(OID oID) {
            try {
                this.put(oID, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getHash(OID oID) {
            return (Hashtable)this.get(oID);
        }

        OIDTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class OIDInfo {
        OIDTable oidTable;

        public OIDInfo() {
            BoxInfo.this = BoxInfo.this;
            this.oidTable = new OIDTable();
            OID oID = new OID(BoxInfo.CARDINALoid);
            Integer n = new Integer(1);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "Cardinal");
            this.oidTable.getHash(oID).put("Gif Ready", new Boolean(true));
            this.oidTable.getHash(oID).put("Image", "Cardinal.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(312, 34));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(3));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("MDIPort11");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            oID = new OID(BoxInfo.RAVENoid);
            n = new Integer(4);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "Raven");
            this.oidTable.getHash(oID).put("Gif Ready", new Boolean(true));
            this.oidTable.getHash(oID).put("Image", "Raven.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(156, 50));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(156, 83));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(156, 120));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(358, 120));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(2));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
        }

        public String getModel(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Model");
        }

        public boolean isGifReady(OID oID) {
            return (Boolean)this.oidTable.getHash(oID).get("Gif Ready");
        }

        public String getImage(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Image");
        }

        public Point getPosition(OID oID) {
            return (Point)this.oidTable.getHash(oID).get("Position");
        }

        public int getScheme(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Scheme");
        }

        public int getNumSlots(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Slots");
        }

        public Point getSlotCoords(OID oID, int n) {
            if (n - 1 >= ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).size()) {
                return new Point(-1, -1);
            }
            return (Point)((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).elementAt(n - 1);
        }

        public int getNumOfExtras(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of extra stuff");
        }

        public String getExtras(OID oID, int n) {
            if (n >= ((Vector)this.oidTable.getHash(oID).get("Extras")).size()) {
                return new String();
            }
            return (String)((Vector)this.oidTable.getHash(oID).get("Extras")).elementAt(n);
        }

        public boolean containsKey(OID oID) {
            return this.oidTable.containsKey(oID);
        }

        public void dispose() {
            this.oidTable.clear();
        }
    }

    private class UFCTable
    extends Hashtable {
        public void create(Integer n) {
            try {
                this.put(n, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getProp(Integer n) {
            if (this.containsKey(n)) {
                return (Hashtable)this.get(n);
            }
            return (Hashtable)this.get(new Integer(999));
        }

        UFCTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class UFCInfo {
        UFCTable ufcTypes;

        public UFCInfo() {
            BoxInfo.this = BoxInfo.this;
            this.ufcTypes = new UFCTable();
            Integer n = new Integer(1);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "Empty");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(false));
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(0));
            n = new Integer(2);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "24_TX");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(true));
            this.ufcTypes.getProp(n).put("Image", "24Port10-100TX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(24));
            n = new Integer(3);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "12_TX");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(true));
            this.ufcTypes.getProp(n).put("Image", "12Port10-100TX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(12));
            n = new Integer(4);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "8_TX");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(false));
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(8));
            n = new Integer(5);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "8_FX");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(true));
            this.ufcTypes.getProp(n).put("Image", "8Port100BaseFX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(8));
            n = new Integer(6);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "2_FX");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(true));
            this.ufcTypes.getProp(n).put("Image", "2Port100BaseFX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(2));
            n = new Integer(8);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "1_SX");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(true));
            this.ufcTypes.getProp(n).put("Image", "1Port1000BaseSX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(1));
            n = new Integer(7);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "2_SX");
            this.ufcTypes.getProp(n).put("DisplayIt", new Boolean(false));
            this.ufcTypes.getProp(n).put("Image", "2Port1000BaseSX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(2));
        }

        public String getName(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Name");
        }

        public boolean displayIt(Integer n) {
            if (!this.ufcTypes.containsKey(n)) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, "displayIt", "Can not recognize type = " + n);
                }
                return false;
            }
            return (Boolean)this.ufcTypes.getProp(n).get("DisplayIt");
        }

        public String getImage(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Image");
        }

        public int getNumPorts(Integer n) {
            return (Integer)this.ufcTypes.getProp(n).get("Number of ports");
        }

        public void dispose() {
            this.ufcTypes.clear();
        }
    }
}

